//---------------------------------------------------------------------------------------
/*!
@file		CA2DErrorDefine.h
@brief		CA2D Error Codes
@author		KONICA MINOLTA, INC.
			Copyright(c) KONICA MINOLTA, INC.  All rights reserved. 2013
*/
//---------------------------------------------------------------------------------------
#ifndef CA2D_ERROR_DEFINE_H_
#define CA2D_ERROR_DEFINE_H_



#define	CA2D_CANCEL							0			//!< Processing was canceled
#define	CA2D_OK								1			//!< Processing completed normally

#define	CA2D_OK_MEASURING					10			//!< Measuring
#define CA2D_OK_RUNNING_DIAGNOSIS			11			//!< Running self-diagnostic

#define	CA2D_ER								-1			//!< A problem occurred in the SDK

#define CA2D_ER_ENABLE						-1000		//!< Initialization is not complete (Initialization failed)
#define CA2D_ER_CONNECT						-1001		//!< Connection is not complete (Connection failed)

#define CA2D_ER_INSTRUMENT					-1050		//!< The instrument information is incorrect

#define CA2D_ER_MEASURING					-1100		//!< Cannot be processed because the measurement is running
#define CA2D_ER_RUNNING_FINDER				-1101		//!< Processing is not possible because the finder is running
#define CA2D_ER_RUNNING_DIAGNOSIS			-1102		//!< Cannot be processed because the instrument diagnostic is running

#define CA2D_ER_DATA_NONE					-1150		//<! No measurement data (not measured or measurement error)

#define CA2D_ER_EXPOSURE					-1200		//!< Not an appropriate exposure time
#define CA2D_ER_AUTOEXPO_OVER				-1201		//!< Failed to calculate the exposure time (overexposed)
#define CA2D_ER_AUTOEXPO_UNDER				-1202		//!< Failed to calculate the exposure time (underexposed)

#define CA2D_ER_TEMPERATURE					-1250		//!< Temperature error

#define CA2D_ER_USERCAL_NONE				-1300		//!< User calibration data has not been set
#define CA2D_ER_USER_CALC					-1301		//!< The user calibration data is invalid (calibration factor could not be calculated)

#define CA2D_ER_PERIODICAL_CAL				-1350		//!< Periodic calibration is now required

#define CA2D_ER_DIAGNOSIS					-1400		//!< Stopped due to an error that occurred during the diagnostic
#define CA2D_ER_DIAGNOSIS_AREA				-1401		//!< There is a problem with the diagnostic results
#define CA2D_ER_DIAGNOSIS_CAUTION			-1402		//!< The diagnostic results have reached the caution level
#define CA2D_ER_DIAGNOSIS_WARNING			-1403		//!< The diagnostic results have reached the warning level

#define CA2D_ER_FILE_NOTFOUND_LENSTYPE		-1500		//!< The lens type file does not exist
#define CA2D_ER_FILE_NOTFOUND_CALIBRATION	-1501		//!< Calibration data file does not exist
#define CA2D_ER_FILE_FORMAT					-1502		//!< Invalid file format
#define CA2D_ER_FILE_ACCESS					-1503		//!< Could not access the file

#define	CA2D_ER_PARAM						-1600		//!< Invalid argument specification
#define CA2D_ER_PARAM_INDEX					-1610		//!< Invalid instrument specification (the specified instrument does not exist)

#define CA2D_ER_PARAM_LENSTYPE				-1620		//!< Invalid lens type specification (lens cannot be used)
#define CA2D_ER_PARAM_LENSPOS				-1621		//!< Invalid focus ring distance indicator specification
#define CA2D_ER_PARAM_EXPOSURE_MODE			-1622		//!< Invalid exposure mode specification
#define CA2D_ER_PARAM_EXPOSURE_INDEX		-1623		//!< Invalid exposure table index number specification
#define CA2D_ER_PARAM_EXPOSURE_AREA			-1624		//!< Invalid exposure setting area setting
#define CA2D_ER_PARAM_SYNC_MODE				-1625		//!< Invalid synchronized measurement mode specification
#define CA2D_ER_PARAM_SYNC_VALUE			-1626		//!< Invalid synchronization frequency specification
#define CA2D_ER_PARAM_ADDITIONAL			-1627		//!< Invalid cumulative number specification
#define CA2D_ER_PARAM_FILTER				-1628		//!< Invalid filter measurement specification
#define CA2D_ER_PARAM_FILTER_INDEX			-1629		//!< Invalid filter type specification
#define CA2D_ER_PARAM_SMEAR					-1630		//!< Invalid smear compensation specification
#define CA2D_ER_PARAM_USERCAL				-1631		//!< Invalid user calibration specification
#define CA2D_ER_PARAM_ROTATION				-1632		//!< Invalid image orientation specification

#define	CA2D_ER_PARAM_FILE					-1640		//!< Invalid file path (folder path)
#define CA2D_ER_PARAM_CALTYPE				-1650		//!< Invalid calibration type specification
#define CA2D_ER_PARAM_GETAREA				-1660		//!< Invalid data acquisition area specification

#define CA2D_ER_PARAM_VALTYPE				-1670		//!< Invalid color specification value specification
#define CA2D_ER_PARAM_RESOLUTION			-1671		//!< Invalid resolution specification
#define CA2D_ER_PARAM_LOWER_LEVEL			-1672		//!< Invalid threshold value specification to process as an under error

#define CA2D_ER_PARAM_EVAL_TYPE				-1680		//!< Invalid layout type specification
#define CA2D_ER_PARAM_EVAL_AREA				-1681		//!< Invalid area specification
#define CA2D_ER_PARAM_EVAL_COUNT			-1682		//!< Invalid detection count specification
#define CA2D_ER_PARAM_EVAL_LEVEL			-1683		//!< Invalid detection threshold value specification

#define CA2D_ER_PARAM_SPOT_COUNT			-1690		//!< Invalid layout count specification
#define CA2D_ER_PARAM_SPOT_SHAPE			-1691		//!< Invalid shape specification
#define CA2D_ER_PARAM_SPOT_SIZE				-1692		//!< Invalid size specification
#define CA2D_ER_PARAM_SPOT_OFFSET_INPUT		-1693		//!< Invalid offset input method specification
#define CA2D_ER_PARAM_SPOT_OFFSET_POS		-1694		//!< Invalid offset layout position specification
#define CA2D_ER_PARAM_SPOT_OFFSET_AREA		-1695		//!< Invalid offset margin specification

#define CA2D_ER_PARAM_NUM					-1700		//!< Invalid evaluation area number specification
#define CA2D_ER_PARAM_POINT					-1701		//!< Invalid spot area specification

#define CA2D_ER_EVAL_CALC					-1710		//!< Could not correctly layout the evaluation areas
#define CA2D_ER_SPOT_CALC					-1711		//!< Could not correctly lay out the spots

#define CA2D_ER_MEASURE_CALC				-1800		//!< Measurement calculation failed


#define CA2D_ER_COMMUNICATION				-5000		//!< Could not communicate with the instrument
#define CA2D_ER_COM_FILTER					-5010		//!< Filter control is not operating correctly
#define CA2D_ER_COM_STATUS					-5020		//!< Get status is not operating correctly
#define CA2D_ER_COM_MEASURE					-5030		//!< Measurement control is not operating correctly
#define CA2D_ER_COM_FINDER					-5040		//!< Finder measurement is not operating correctly
#define CA2D_ER_COM_SHUTTERSPEED			-5050		//!< Shutter speed control is not operating correctly
#define CA2D_ER_COM_GAIN					-5060		//!< Gain control is not operating correctly
#define CA2D_ER_COM_ADDTIONAL				-5070		//!< Cumulative number control is not operating correctly
#define CA2D_ER_COM_GETDATA					-5110		//!< Data acquisition control is not operating correctly
#define CA2D_ER_COM_TEMPERATURE				-5120		//!< emperature control is not operating correctly
#define CA2D_ER_COM_FAN						-5130		//!< Fan control is not operating correctly
#define CA2D_ER_COM_MOTOR					-5140		//!< Motor control is not operating correctly
#define CA2D_ER_COM_MEMORY					-5150		//!< Insufficient memory
#define CA2D_ER_COM_DETECT					-5200		//!< The instrument was disconnected
#define CA2D_ER_USBDLL						-5300		//!< USB driver control is not operating correctly


#endif //CA2D_ERROR_DEFINE_H_
